;***********************************************************************************************;
; File 16f877_LVP.ASM																																						;
; Assembly code using 20 MHz clock with the PIC16F877A microcontroller. Using a PCB with ISP		;
; programmer inclueded. PortA all analouge inputs, PortC, PortD inputs for controllermessages,	;
; PortA,4 out to serial 8 digit LED, PortC, 0-4 for indication LEDs.														;
; Midi out on RC6TX, set BRGH=Hi, load SPBRG registor with 0X28 for midi baudrate at 31.250Kb		;		
;																																																;
; Author  : M.Hug																																								;
; Written : Oct. 2005																																						;
; Last update: 1st. Nov. 2007																																		;
;***********************************************************************************************;

LIST P=16F877A
LIST C=132
RADIX HEX

#include	  "p16F877A.inc"
#include	  "init_macro.inc"
#include	  "start_macro.inc"
#include	  "define_macro.inc"

__config  _HS_OSC & _WDT_OFF & _PWRTE_OFF &_LVP_ON & _BODEN_OFF

				w	   equ 0X00
				f    equ 0X01
				PC   equ 0X02

init_macro	; sets variables to program memory.

	    	org	  0x00
	    	goto  start
      	org   0x04
       		        
start	start_macro


				res_LED									; reset PORTA, LED's 16F690.
				
    		call		chkINI					; MISC.lib (read data/ delay/ Var. INI 1 or 0?)
    		clrf		Mode
				bsf			PORTC,4								
				clrf		LEDs
				
				
				pausems	.200
							
				movlw 	b'00000010'			; page 0, subpage 2.
      	movwf 	PCLATH
				movf		Setup,0					; number "1" for 7-digit display to be sent.
 				call		ser_dir					; P2PSEND.LIB
      	clrf  	PCLATH 
				
				blue_

		

			
loop   	clrf  	TEMP2
				movlw 	0x0C
				movwf 	Oct
				
				btfss		Flag,0
				goto		d_flow					; if Flag,0=1 prg. explores TOIF and goes to count_INT_set.
				btfsc		INTCON,2				; or jumps this step.
				call		count_INT_set		; MISC.lib.
d_flow	movlw 	b'000001110'   	; page 1, subpage 6.
      	movwf 	PCLATH
      	call  	DAC_0     
       	clrf  	PCLATH

     		movf  	PORTD,0		 			; PAD_01, RD3, level 1, LED blue off, LED red on. 
      	xorlw 	B'00001000'
      	btfsc 	STATUS,2
      	call  	PAD_01					; MISC.lib (level switch).

				movf  	PORTD,0		 			; PAD_03, RD0, ContrSW_1 (Contr.Message 0x06).
				movwf 	TEMP2		        
      	xorlw 	B'00000001'
      	btfsc 	STATUS,2
      	call  	PAD_02_03

 			  movf  	PORTD,0		 			; PAD_02, RD1, ContrSW_2 (Contr.Message 0x12).
       	movwf 	TEMP2
      	xorlw 	B'00000010'
      	btfsc 	STATUS,2
      	call  	PAD_02_03

				movf  	PORTD,0					; RD2, PAD mode, LED green On.		 
      	xorlw 	B'00000100'	 		; if PORTD,2 =HI set ADC to NoteOn(X.)
      	btfsc 	STATUS,2
      	call  	PAD_04			 		; ADC to NoteOnX off or on (Mode.lib).
				
      	movf  	PORTB,0		 			; RB7 volume - (level 1).
      	movwf 	TEMP2			 			; data for table in ContrSW.lib.  
      	xorlw 	B'10000000'
      	btfsc 	STATUS,2
      	call  	PAD_05

      	movf  	PORTB,0		 			; RB6 volume + (level 1).
      	movwf 	TEMP2			 			; data for table in ContrSW.lib.
      	xorlw 	B'01000000'
      	btfsc 	STATUS,2
      	call  	PAD_06

      	movf  	PORTD,0		 			; RD5, controller - (0X17).	
      	xorlw 	B'00100000'
      	btfsc 	STATUS,2
    		call  	PAD_07

				movf  	PORTD,0		 			; RD4, controller + (0X17.)
   			xorlw 	B'00010000'
 				btfsc 	STATUS,2
   			call  	PAD_08	

      	movf  	PORTB,0       	; RB2, PAD octave -.
				movwf		TEMP2  
      	xorlw 	B'00000100'
      	btfsc 	STATUS,2
      	call  	PAD_09

	     	movf  	PORTC,0       	; RC5 octave + (replaces RB3)
				movwf 	TEMP2	 
      	xorlw 	B'01110000'			; Pin RC4 set Hi because of BLUE LED, level 1 indication. 	     	 
      	btfsc 	STATUS,2				; RC6 is driven Hi!!!
      	call  	PAD_10

				movf  	PORTC,0       	; RC5 octave + (replaces RB3)
				movwf 	TEMP2	 
      	xorlw 	B'01101000'			; Pin RC3 set Hi because of RED LED, level 1 indication. 	     	 
      	btfsc 	STATUS,2				; RC6 is driven Hi!!!
      	call  	PAD_10
								
				movf  	PORTB,0  				; RB4 note -.
				movwf 	TEMP2		       
      	xorlw 	B'00010000'	 
      	btfsc 	STATUS,2
      	call  	PAD_11    

      	movf  	PORTB,0		 			; RB5 note +.
				movwf 	TEMP2		 
      	xorlw 	B'00100000'
      	btfsc 	STATUS,2
      	call  	PAD_12   

				movf  	PORTB,0		 			; RB0, CN1, Pin1 audioCh_down. (MISC.lib).
      	xorlw 	B'00000001'
      	btfsc 	STATUS,2
      	call  	PAD_13					; MISC.lib            
              	      	  
      	movf  	PORTB,0		 			; RB1, CN1, Pin2 audioCh_up (MISC.lib).
      	xorlw 	B'00000010'
      	btfsc 	STATUS,2
      	call  	PAD_14					; MISC.lib 
 
      	movf  	PORTD,0        	; RD1 Program -.  
      	xorlw 	B'10000000'    
      	btfsc 	STATUS,2
      	call  	PAD_15     	

				movf  	PORTD,0        	; RD6 Program +.    
      	xorlw 	B'01000000'     
      	btfsc 	STATUS,2
      	call  	PAD_16

      	movlw 	0x00           	; explores TEMP1,0-7 for velocity values
      	subwf 	TEMP1          	; if velocit >0 the routin transm.lib  
      	btfsc 	STATUS,2       	; sends MIDI DATA
       	goto  	loop
 	          	
				movlw 	b'00001000'     ; DEBUG (b'00000110')page0, subpage 6.
      	movwf 	PCLATH
        call 		transm
        clrf 		PCLATH
				bcf  		STATUS, RP0			; make shure using bank 0.
       	goto 		loop
  
;;
;;

PAD_02_03   	btfsc	PORTC,4						; PAD_02/03, LED_blue=Hi(level 0) to SnapShot1.lib
							goto	SnapShot_1				; sends only ctr.messages (mute midi).
ContrSwitch		movlw b'00011011'       ; page 3, subpage 3.
      				movwf PCLATH
      				call  ContrSW						; ContrSW.lib       
      				clrf  PCLATH
						 return

PAD_04			 	movlw b'00000101'       ; PAD_04, level 1 and level 2 leeds to Mode.
       				movwf PCLATH						; page0, subpage 5 
      				call  Mode_On_Off				; Mode.lib        
       				clrf  PCLATH
      	     return



PAD_05		   	btfsc	PORTC,4						; LED_blue=Hi(level 0) leeds to ContrSW_P (ContrSW.lib)
							goto	ContrSW_P
							movlw b'00010111'       ; page 2, subpage 7.
      				movwf PCLATH
      				call  VolumeDown        
      				clrf  PCLATH
      	     return

PAD_06	    	btfsc	PORTC,4						; LED_blue=Hi(level 0) leeds to ContrSW_P (ContrSW.lib)
							goto	ContrSW_P 
							movlw b'00010110'       ; page 2, subpage  6.
      				movwf PCLATH
      				call  VolumeUp        
      				clrf  PCLATH
      	     return

PAD_07	 			btfsc	PORTC,3						; PAD_02/03, LED_red=Hi(level 1) leeds to SliderM_P.(Slider0.lib).
							goto	SliderM_P	
							movlw b'000011000'      ; page 3, subpage 0.
      				movwf PCLATH
      				call  bank_down 				; DEBUG bank lib.      
      				clrf  PCLATH
      	     return

PAD_08	 			btfsc	PORTC,3						; PAD_02/03, LED_red=Hi(level 1) leeds to Slider_P. (Slider0.lib).
							goto	Slider_P	
							clrf	MidiStat
							movlw b'000011000'      ; page3, subpage 0.
      				movwf PCLATH
							call  bank_up						; bank lib.       
      				clrf  PCLATH
      	     return
      	   
PAD_09	 			btfss	PORTC,4
							goto	ContrSW_P	
							movlw b'000010101'      ; page2, subpage 5.
      				movwf PCLATH
      				call  octavM       
      				clrf  PCLATH
      	     return
PAD_10  			btfss	PORTC,4
							goto	ContrSW_P	
							movlw b'000010101'      ; page2, subpage 5.
      				movwf PCLATH
							call  octave       
      				clrf  PCLATH
      				clrf  TEMP1
		    		 return
     	   
PAD_11			 	btfss	PORTC,4						; PAD_02/03, level 1 leeds to SnapShot.
							goto	ContrSwitch	
							movlw b'00000100'       ; page0, subpage 4.
      				movwf PCLATH
      				call  configNoteM         
      				clrf  PCLATH
      	     return
      	   
PAD_12			 	btfss	PORTC,4						; PAD_02/03, level 1 leeds to SnapShot.
							goto	ContrSwitch		
							movlw b'00000011'       ; page0, subpage 3.
      				movwf PCLATH
      				call  configNote         
      				clrf  PCLATH
      	     return
      	   
PAD_15     		movlw b'000010011'      ; page2, subpage 3.
       				movwf PCLATH
       				call  confPrgM					; prg.lib (prg. +(.       
      				clrf  PCLATH
      	     return

PAD_16     		movlw b'000010011'      ; page2, subpage 3.
      				movwf PCLATH
      				call  confPrg						; prgM.lib (prg. -).     
       				clrf  PCLATH
      	     return 
      	   

configChP   	movlw b'00000100'       ; page0, subpage 4.
      				movwf PCLATH						; inputs up
      				call  configCh        
      				clrf  PCLATH
      	     return
      	   
configChM_P 	movlw b'00000110'       ; page0, subpage 6.
      				movwf PCLATH						; inputs up
      				call  configChM        
      				clrf  PCLATH
      	     return
 
inicialP    	movlw b'00001101'       ; page1, subpage 5.
      				movwf PCLATH
      				call  initial       
      				clrf  PCLATH
      	     return

storedataP 		movlw b'00010000'       ; page2, subpage 0.
      				movwf PCLATH
      				call  storedata        
      				clrf  PCLATH
      	     return

Slider_P    	movlw b'00011001'       ; page3, subpage 1.
      				movwf PCLATH
       				call  Slider0Up
       				bcf   STATUS,5					; Slider0.lib.        
      				clrf  PCLATH
       	     return
      	   
SliderM_P   	movlw b'00011010'       ; page3, subpage 2.
      				movwf PCLATH						
       				call  Slider0Down
       				bcf   STATUS,5					; Slider0.lib.        
     					clrf  PCLATH
      	     return
							
ContrSW_P   	movlw b'00011011'       ; page3, subpage 3.
      				movwf PCLATH
      				call  ContrSW       
      				clrf  PCLATH
      			 return

SnapShot_1	 	btfsc	TEMP2,1						; PAD 2 (hold ON/OFF) directs to SnapShot2.lib.
							goto	SnapShot_2
							movlw b'00010010'       ; page2, subpage 2.
      				movwf PCLATH
       				call  Snap1							; PAD 3 (mute ON/OFF) SnapShot2.lib.
       				bcf   STATUS,5		     	; bank0 after 0 cut.        
     					clrf  PCLATH
						 return
						  
SnapShot_2		movlw b'00010001'       ; page2, subpage 1.
      				movwf PCLATH
       				call  Snap2							; SnapShot1.lib
       				bcf   STATUS,5		     	; bank0 after 0 cut.        
     					clrf  PCLATH
      	     return      	   
;**
;**




bit9   		goto  loop        
       
;*************delay3 14ms / delay4 2ms *************************************

              ORG   0X0500
delay3        movlw    0x46
              movwf    Count2    
delay_3       clrwdt
		    			decfsz   Count1               
              goto     delay_3
              decfsz   Count2
              goto     delay_3
             return

delay4        movlw    0x0A
              movwf    Count2    
delay_4       clrwdt
		    			decfsz   Count1               
              goto     delay_4
              decfsz   Count2
              goto     delay_4
             return
             
;;
;;

;******************************* menue routine  *********************************
;**

menu					blue_off
							red_off
							yell_bl								; LED yellow blink
							bsf		INTCON,2				; set TOIF back to avoid prg- switch to menu.
										
							movlw 0x18						; number "m" to be sent.
  						movwf sendreg					
							call	ser_dirA				; serial communication to RA4. 
							clrf	TMR0

Ch_Set_loop		movf  PORTD,0		 			; RD1, store_data. 
      				xorlw B'00000010'
      				btfsc STATUS,2
      				call  storedataP

							movf  PORTD,0		 			; RD0, initialize.
      				xorlw B'00000100'			; PAD 04 used to initiate data.
      				btfsc STATUS,2
      				call  inicialP

							movlw B'00000010'  		; RB1, midi channel up PortB,RB0.  
      				movwf TEMP1
      				movf  PORTB,0        
      				subwf TEMP1,0
      				btfsc STATUS,2
      				call  configChP 
       
							movlw B'00000001'  		; RB0, midi channel down PortB,RB1.   
      				movwf TEMP1
      				movf  PORTB,0        
      				subwf TEMP1,0
      				btfsc STATUS,2
      				call  configChM_P
      				
      				
      				btfsc TEMP2,0
      				goto	out_of_menu			; var is set in store_data.lib.
      			
      				movf  PORTD,0		 			; RD3, PAD_01, back to level, LED red on. 
      				xorlw B'00001000'
      				btfss STATUS,2
      				goto  Ch_Set_loop			
			
      		    
out_of_menu		movlw b'00000010'   	; page 0, subpage  2.
      				movwf PCLATH	
							movf	Setup,0		 			; number "X" for 7-digit display to be sent.
 							call  ser_dir		 			; P2PSEND.LIB
      				clrf  PCLATH
							bcf		Flag,0					; sets menu-flag byte back.
      		   	call  Mode_ON_OFF			; STATUS.lib explores registor "Mode".
      		   	yell_bl	
      		   return	 

;*********************** ORG *****************************************************
			 
		   
				ORG  0X0160	 							; page0, subpage 1.
		   	include "MISC.lib"
						 
		   	ORG  0X0200			 					; page0, subpage 1.
		   	include "P2PSEND.lib"

		   	ORG  0X0300			 					; page 0, subpage 3.
		   	include "configNote.lib"
			 
		   	ORG  0X0380			 					; page 0, subpage 3.
		   	include "configNoteM.lib"
			 
		   	ORG  0X0400			 					; page 0, subpage 4.
		   	include "configCh.lib"
			 
       	ORG  0X0480			 					; page 0, subpage 4.
		   	include "configChM.lib"
			 
		   	ORG  0X0560			 					; page 0, subpage 5.
		   	include "Mode.lib"
             
       	ORG  0X0650			 					; page 0, subpage 6.
		   	include "Status.lib"
       	
       	ORG  0X0800			 					; page 0, subpage 8.
       	include "transm.lib"
             
      	ORG  0X0A50             	; page 1, subpage 3.
       	include "read_data.lib" 
         
        ORG		0x0C00
        include	"LED_r_b.lib"			; page 1, subpage 4.
        
        ORG  0X0D00           		; page 1, subpage 5.
       	include "initial.lib" 
			                   
       	ORG  0X0E00             	; page 1, subpage 6.
       	include "DAC.lib" 
             
       	ORG  0X1000             	; page 2, subpage 0.
       	include "store_data.lib"

				ORG  0X1100             	; page 2, subpage 1.
       	include "SnapShot1.lib"

				ORG  0X1200             	; page 2, subpage 2.
       	include "SnapShot2.lib"
             
       	ORG  0X1300             	; page 2, subpage 3.
       	include "prg.lib" 
             
       	ORG  0X1390             	; page 2, subpage 3.
       	include "prgM.lib" 
             
       	ORG  0X1420             	; page 2, subpage 4.
       	include "trans_contr.lib" 

		   	ORG  0X1550             	; page 2, subpage 5.
       	include "octav.lib" 
             
       	ORG  0X15E8             	; page 2, subpage 6.
       	include "octavM.lib"  
             
       	ORG  0X1650             	; page 2, subpage 6.
       	include "volume.lib" 
             
       	ORG  0X1728             	; page 2, subpage 7.
       	include "volumeM.lib" 
                                     
       	ORG  0X1800			 					; page 3, subpage 0.
       	include "bank.lib" 
             
       	ORG  0X1980			 					; DEBUG 0X1970 page 3, subpage 1.
       	include "Slider0.lib" 
             
		   	ORG  0X1B6F             	; DEBUG 0X1B58 page 3, subpage 3.
       	include "ContrSW.lib" 
;**
;**
    	              
end




