;**********************************************************************************************;
; File 16f877_LVP.ASM															;
; Assembly code using 20 MHz clock with the PIC16F877A microcontroller. Using a PCB with ISP	;
; programmer inclueded. PortA all analouge inputs, PortC, PortD inputs for controllermessages,	;
; PortA,4 out to serial 8 digit LED, PortC, 0-4 for indication LEDs.														;
; Midi out on RC6TX, set BRGH=Hi, load SPBRG registor with 0X28 for midi baudrate at 31.250Kb		;		
;																																																;
; Author  : M.Hug																																								;
; Written : Oct. 2005																																						;
; Last update: 1st. Nov. 2007																																		;
;***********************************************************************************************;

LIST P=16F877A
LIST C=132
RADIX HEX

#include	  "p16F877A.inc"
#include	  "init_macro.inc"
#include	  "start_macro.inc"
#include	  "define_macro.inc"

__config  _HS_OSC & _WDT_OFF & _PWRTE_OFF &_LVP_ON & _BODEN_OFF

				w	   equ 0X00
				f    equ 0X01
				PC   equ 0X02

init_macro	; sets variables to program memory.

	    	org	  0x00
	    	goto  start
      	org   0x04
       		        
start	start_macro

    		call		chkINI					; MISC.lib (read data/ delay/ Var. INI 1 or 0?)
    		
    		movlw 	b'00000010'			; page 0, subpage 2.
      	movwf 	PCLATH
				movf		Setup,0					; send "1" to 7-digit display.
 				call		ser_dir					; P2PSEND.LIB
      	clrf  	PCLATH

				blue_										; LED_blue ON/OFF.
							
				bsf			STATUS, RP0			; to bank 1.
				movlw		0x00						; dec. 20.
				movwf		ON_del_0
				movwf		ON_del_1
				movlw		0xFF
				movwf		Vel_HOLD_0			; initial value is set to 0xFF.
				bcf			STATUS, RP0			; to bank 0.
				bsf			CTR_HOLD,0			; flag 0 = controller messages send off.
				bsf			CTR_HOLD,1			; flag 0 = controller messages send off.
				clrf		SEND_YES_NO			; DEBUG flag 1 = NoteOn messages send until next trigger event.
				clrf		SEND_OFF				; flag 0 = ****
				clrf		HOLD						; DEBUG experiment to send only Ctr.-messages.
				clrf		POLIFONIC				; DEBUG.
			
				
loop   	clrf  	TEMP2
				movlw 	0x0C
				movwf 	Oct
				
				btfss		Flag,0
				goto		d_flow					; if Flag,0=1 prg. explores TOIF and goes to count_INT_set.
				btfsc		INTCON,2				; or jumps this step.
				call		count_INT_set
d_flow	movlw 	b'000001111'   	; page 1, subpage 7.
      	movwf 	PCLATH
      	call  	DAC_0     
       	clrf  	PCLATH

     		movf  	PORTD,0		 			; PAD_01, RD3, level 1, LED blue off, LED red on. 
      	xorlw 	B'00001000'
      	btfsc 	STATUS,2
      	call  	PAD_01					; MISC.lib (level switch).

				movf  	PORTD,0		 			; PAD_03, RD0, ContrSW_1 (Contr.Message 0x06).
				movwf 	TEMP2		        
      	xorlw 	B'00000001'
      	btfsc 	STATUS,2
      	call  	PAD_02_03

			  movf  	PORTD,0		 			; PAD_02, RD1, ContrSW_2 (Contr.Message 0x12).
       	movwf 	TEMP2
      	xorlw 	B'00000010'
      	btfsc 	STATUS,2
      	call  	PAD_02_03

				movf  	PORTD,0					; RD2, PAD mode, LED green On.		 
      	xorlw 	B'00000100'	 		; if PORTD,2 =HI set ADC to NoteOn(X.)
      	btfsc 	STATUS,2
      	call  	PAD_04			 		; ADC to NoteOnX off or on (Mode.lib).
				
      	movf  	PORTB,0		 			; RB7 volume -.
      	movwf 	TEMP2			 			; data for table in ContrSW.lib.  
      	xorlw 	B'10000000'
      	btfsc 	STATUS,2
      	call  	PAD_05

      	movf  	PORTB,0		 			; RB6 volume +.
      	movwf 	TEMP2			 			; data for table in ContrSW.lib.
      	xorlw 	B'01000000'
      	btfsc 	STATUS,2
      	call  	PAD_06

      	movf  	PORTD,0		 			; RD5, controller - (0X17).	
      	xorlw 	B'00100000'
      	btfsc 	STATUS,2
    		call  	PAD_07

				movf  	PORTD,0		 			; RD4, controller + (0X17.)
   			xorlw 	B'00010000'
 				btfsc 	STATUS,2
   			call  	PAD_08	

      	movf  	PORTB,0       	; RB2, PAD octave -.
				movwf		TEMP2  
      	xorlw 	B'00000100'
      	btfsc 	STATUS,2
      	call  	PAD_09

	     	movf  	PORTC,0       	; RC5 octave + (replaces RB3)
				movwf 	TEMP2	 
      	xorlw 	B'01110000'			; Pin RC4 set Hi because of BLUE LED, level 1 indication. 	     	 
      	btfsc 	STATUS,2				; RC6 is driven Hi!!!
      	call  	PAD_10

				movf  	PORTC,0       	; RC5 octave + (replaces RB3) 
      	xorlw 	B'01101000'			; Pin RC4 set Hi because of RED LED, level 1 indication. 	     	 
      	btfsc 	STATUS,2				; RC6 is driven Hi!!!
      	call  	PAD_10

				movf  	PORTB,0  				; RB4 note -.
				movwf 	TEMP2		       
      	xorlw 	B'00010000'	 
      	btfsc 	STATUS,2
      	call  	PAD_11    

      	movf  	PORTB,0		 			; RB5 note +.
				movwf 	TEMP2		 
      	xorlw 	B'00100000'
      	btfsc 	STATUS,2
      	call  	PAD_12   

				movf  	PORTB,0		 			; RB0, CN1, Pin1 audioCh_down. (MISC.lib).
      	xorlw 	B'00000001'
      	btfsc 	STATUS,2
      	call  	PAD_13					; MISC.lib            
              	      	  
      	movf  	PORTB,0		 			; RB1, CN1, Pin2 audioCh_up (MISC.lib).
      	xorlw 	B'00000010'
      	btfsc 	STATUS,2
      	call  	PAD_14					; MISC.lib 
 
      	movf  	PORTD,0        	; RD1 Program -.  
      	xorlw 	B'10000000'    
      	btfsc 	STATUS,2
      	call  	PAD_15     	

				movf  	PORTD,0        	; RD6 Program +.    
      	xorlw 	B'01000000'     
      	btfsc 	STATUS,2
      	call  	PAD_16
      	
      	movlw 	0x00           	; explores TEMP1,0-7 for velocity values
      	subwf 	OFF          		; if velocit >0 the routin transm.lib  
      	btfsc 	STATUS,Z       	; sends MIDI DATA
       	goto  	tr_mitt 
   	       	         
      	movlw 	0x00           	; explores TEMP1,0-7 for velocity values
      	subwf 	TEMP1          	; if velocit >0 the routin transm.lib  
      	btfsc 	STATUS,2       	; sends MIDI DATA
       	goto  	loop
      	    	
      	
tr_mitt	movlw 	b'00000110'     ; page0, subpage 6.
      	movwf 	PCLATH
        call 		transm
        clrf 		PCLATH
				bcf  		STATUS, RP0			; make shure using bank 0.
       	goto 		loop
  
;;
;;

PAD_02_03   	btfsc	PORTC,4						; PAD_02/03, LED_blue=Hi(level 0) leeds to SnapShot_1.
							goto	SnapShot_1	
ContrSwitch		movlw b'00011011'       ; page 3, subpage 3.
      				movwf PCLATH
      				call  ContrSW						; ContrSW.lib       
      				clrf  PCLATH
						 return

PAD_04			 	movlw b'00000101'       ; PAD_04, level 1 and level 2 leeds to Mode.
       				movwf PCLATH						; page0, subpage 5 
      				call  Mode_On_Off				; Mode.lib        
       				clrf  PCLATH
      	     return



PAD_05		   	btfsc	PORTC,4						; LED_blue=Hi(level 0) leeds to ContrSW_P (ContrSW.lib)
							goto	ContrSW_P
							movlw b'00010111'       ; page 2, subpage 7.
      				movwf PCLATH
      				call  VolumeDown        
      				clrf  PCLATH
      	     return

PAD_06	    	btfsc	PORTC,4						; LED_blue=Hi(level 0) leeds to ContrSW_P (ContrSW.lib)
							goto	ContrSW_P 
							movlw b'00010110'       ; page 2, subpage  6.
      				movwf PCLATH
      				call  VolumeUp        
      				clrf  PCLATH
      	     return

PAD_07	 			btfsc	PORTC,3						; PAD_02/03, LED_red=Hi(level 1) leeds to SliderM_P.
							goto	SliderM_P	
							movlw b'000011000'      ; page 3, subpage 0.
      				movwf PCLATH
      				call  bank_down 				; DEBUG bank lib.      
      				clrf  PCLATH
      	     return

PAD_08	 			btfsc	PORTC,3						; PAD_02/03, LED_red=Hi(level 1) leeds to Slider_P.
							goto	Slider_P	
							clrf	MidiStat
							movlw b'000011000'      ; page3, subpage 0.
      				movwf PCLATH
							call  bank_up						; bank lib.       
      				clrf  PCLATH
      	     return
      	   
PAD_09	 			btfss	PORTC,4
							goto	ContrSW_P	
							movlw b'000010101'      ; page2, subpage 5.
      				movwf PCLATH
      				call  octavM       
      				clrf  PCLATH
      	     return
PAD_10  			btfss	PORTC,4
							goto	ContrSW_P	
							movlw b'000010101'      ; page2, subpage 5.
      				movwf PCLATH
							call  octave       
      				clrf  PCLATH
      				clrf  TEMP1
		    		 return
     	   
PAD_11			 	btfss	PORTC,4						; PAD_02/03, level 1 leeds to SnapShot.
							goto	ContrSwitch	
							movlw b'00000100'       ; page0, subpage 4.
      				movwf PCLATH
      				call  configNoteM         
      				clrf  PCLATH
      	     return
      	   
PAD_12			 	btfss	PORTC,4						; PAD_02/03, level 1 leeds to SnapShot.
							goto	ContrSwitch		
							movlw b'00000011'       ; page0, subpage 3.
      				movwf PCLATH
      				call  configNote         
      				clrf  PCLATH
      	     return
      	   
PAD_15     		movlw b'000010011'      ; page2, subpage 3.
       				movwf PCLATH
       				call  confPrgM					; prg.lib (prg. +(.       
      				clrf  PCLATH
      	     return

PAD_16     		movlw b'000010011'      ; page2, subpage 3.
      				movwf PCLATH
      				call  confPrg						; prgM.lib (prg. -).     
       				clrf  PCLATH
      	     return 
      	   

configChP   	movlw b'00000100'       ; page0, subpage 4.
      				movwf PCLATH						; inputs up
      				call  configCh        
      				clrf  PCLATH
      	     return
      	   
configChM_P 	movlw b'00000110'       ; page0, subpage 6.
      				movwf PCLATH						; inputs up
      				call  configChM        
      				clrf  PCLATH
      	     return
 
inicialP    	movlw b'00000010'       ; page0, subpage 2.
      				movwf PCLATH
      				call  initial       
      				clrf  PCLATH
      	     return

storedataP 		movlw b'00010000'       ; page2, subpage 0.
      				movwf PCLATH
      				call  storedata        
      				clrf  PCLATH
      	     return

Slider_P    	movlw b'00011010'       ; page3, subpage 2.
      				movwf PCLATH
       				call  Slider0Up
       				bcf   STATUS,5					; bank0 after 0cut.        
      				clrf  PCLATH
       	     return
      	   
SliderM_P   	movlw b'00011010'       ; page3, subpage 2.
      				movwf PCLATH						
       				call  Slider0Down
       				bcf   STATUS,5					; bank0 after 0cut.        
     					clrf  PCLATH
      	     return
      	   
Slider1_P   	movlw b'00001000'       ; page1, subpage 0.
      				movwf PCLATH						; Slider1.lib
       				call  Slider1Up
       				bcf   STATUS,5		     	; bank0 after 0cut.        
      				clrf  PCLATH
       	     return
      	   
Slider1M_P  	movlw b'00001000'       ; page1, subpage 0.
      				movwf PCLATH						; Slider1.lib
       				call  Slider1Down
       				bcf   STATUS,5		     	; bank0 after 0cut.        
     					clrf  PCLATH
						 return
							
ContrSW_P   	movlw b'00011011'       ; page3, subpage 3.
      				movwf PCLATH
      				call  ContrSW       
      				clrf  PCLATH
      			 return

SnapShot_1	 	btfsc	TEMP2,1						; switch leeds to SnapShot1.lib or SnapShot2.lib.
							goto	SnapShot_2
							movlw b'00010010'       ; page2, subpage 2.
      				movwf PCLATH
       				call  Snap2							; SnapShot1.lib
       				bcf   STATUS,5		     	; bank0 after 0cut.        
     					clrf  PCLATH
						 return
						  
SnapShot_2		movlw b'00010010'       ; page2, subpage 2.
      				movwf PCLATH
       				call  Snap1							; SnapShot2.lib
       				bcf   STATUS,5		     	; bank0 after 0cut.        
     					clrf  PCLATH
      	     return      	   
;**
;**




bit9   		goto  loop        
       
;*************delay3 14ms / delay4 2ms *************************************

              ORG   0X0500
delay3        movlw    0x46
              movwf    Count2    
delay_3       clrwdt
		    			decfsz   Count1               
              goto     delay_3
              decfsz   Count2
              goto     delay_3
             return

delay4        movlw    0x0A
              movwf    Count2    
delay_4       clrwdt
		    			decfsz   Count1               
              goto     delay_4
              decfsz   Count2
              goto     delay_4
             return
             
;;
;;

;******************************* menue routine  *********************************
;**

menu					bcf		LED_blue
							bcf		LED_red
							bsf		INTCON,2				; set TOIF back to avoid prg- switch to menu.
										
							movlw 0x23						; number "M" to be sent.
  						movwf sendreg					; store.
							call	ser_dirA				; serial communication to RA4. 
							bsf	 	LED_yellow			; LED white On.
							clrf	TMR0

Ch_Set_loop		btfsc	INTCON,2
							call	blinking

							movf  PORTD,0		 			; RD1, store_data. 
      				xorlw B'00000010'
      				btfsc STATUS,2
      				call  storedataP

							movf  PORTD,0		 			; RD0, initialize.
      				xorlw B'00000001'
      				btfsc STATUS,2
      				call  inicialP

							movlw B'00000010'  		; RB1, midi channel up PortB,RB0.  
      				movwf TEMP1
      				movf  PORTB,0        
      				subwf TEMP1,0
      				btfsc STATUS,2
      				call  configChP 
       
							movlw B'00000001'  		; RB0, midi channel down PortB,RB1.   
      				movwf TEMP1
      				movf  PORTB,0        
      				subwf TEMP1,0
      				btfsc STATUS,2
      				call  configChM_P
      			
      				movf  PORTD,0		 			; RD3, PAD_01, back to level, LED red on. 
      				xorlw B'00001000'
      				btfss STATUS,2
      				goto  Ch_Set_loop			

							
      		    bcf   PORTC,2		 			; white LED Off.
							movlw b'00000001'   	; page 0, subpage  1.
      				movwf PCLATH	
							movf	Setup,0		 			; number "X" for 7-digit display to be sent.
 							call  ser_dir		 			; P2PSEND.LIB
      				clrf  PCLATH
							bsf	 	LED_red		 			; red LRD On.
      		   	bcf		Flag,0					; sets menu-flag byte back.
      		   return	 

;*********************** blinking LED**********************************************				

blinking			bcf		INTCON,2
							movf  count,0		 
      				xorlw 0x5A						; with 0X5A timer set to 450 msec.
      				btfsc STATUS,Z
      				goto	blink
							incf	count,f
						 return
blink					clrf	count
							clrf	TMR0
							movf	counter,0
							xorlw 0x02						; total delay-time 450 msec. 
      				btfsc STATUS,Z
       				goto	LED_ON
       				incf	counter,f
       			 return
LED_ON				btfsc	PORTC,2
							goto	LED_OFF
							bsf		LED_yellow
						 return
LED_OFF				bcf		LED_yellow
						 return		

;**
;**

;*********************** ORG *****************************************************
			 
		   
				ORG  0X0140		 						; page0, subpage 1.
		   	include "MISC.lib"
						 
		   	ORG  0X0220			 					; page0, subpage 2.
		   	include "P2PSEND.lib"
			 	
		   	ORG  0X0260            		; page0, subpage 2.
       	include "initial.lib" 
			 
		   	ORG  0X0300			 					; page0, subpage 3.
		   	include "configNote.lib"
			 
		   	ORG  0X0380			 					; page0, subpage 3.
		   	include "configNoteM.lib"
			 
		   	ORG  0X0400			 					; page0, subpage 4.
		   	include "configCh.lib"
			 
       	ORG  0X0480			 					; page0, subpage 4.
		   	include "configChM.lib"
			 
		   	ORG  0X0550			 					; page0, subpage 5.
		   	include "Mode.lib"
             
       	ORG  0X0600			 					; page1, subpage 6.
       	include "transm.lib"
             
       	ORG  0X0850             	; page1, subpage 0.
       	include "Slider1.lib"  
                
       	ORG  0X0A50             	; page1, subpage 3.
       	include "read_data.lib" 
        
        ORG  0X0E00			 					; 0X01F8 DEBUG 0X1D0 page0, subpage 1.
		   	include "Status.lib"
             
       	ORG  0X0F00             	; DEBUG 0xE50 page1, subpage 6.
       	include "DAC.lib" 
             
       	ORG  0X1000             	; page2, subpage 0.
       	include "store_data.lib"

				ORG  0X1210             	; page2, subpage 2.
       	include "SnapShot1.lib"

				ORG  0X1290             	; page2, subpage 2.
       	include "SnapShot2.lib"
             
       	ORG  0X1300             	; page2, subpage 3.
       	include "prg.lib" 
             
       	ORG  0X1380             	; page2, subpage 3.
       	include "prgM.lib" 
             
       	ORG  0X1400             	; page2, subpage 4.
       	include "trans_contr.lib" 

		   	ORG  0X1550             	; page2, subpage 5.
       	include "octav.lib" 
             
       	ORG  0X15E8             	; page2, subpage 6.
       	include "octavM.lib" 
             
       	ORG  0X1650             	; page2, subpage 6.
       	include "volume.lib" 
             
       	ORG  0X1728             	; page2, subpage 7.
       	include "volumeM.lib" 
                                     
       	ORG  0X1800			 					; page3, subpage 0.
       	include "bank.lib" 
             
       	ORG  0X1968			 					; page3, subpage 1.
       	include "Slider0.lib" 
             
		   	ORG  0X1B58             	; page3, subpage 3.
       	include "ContrSW.lib" 
;**
;**
    	              
end




