;include file 16f877A macros------------------------------------------------
#define RA1 PORTA,1
#define RA2 PORTA,2
#define RA3 PORTA,3
#define RA4 PORTA,4
#define RB0 PORTB,0
#define RB1 PORTB,1
#define RB2 PORTB,2
#define RB3 PORTB,3
#define RB4 PORTB,4
#define RB5 PORTB,5
#define RB6 PORTB,6
#define RB7 PORTB,7
#define LED_white	PORTC,0
#define LED_green	PORTC,1
#define LED_yellow	PORTC,2	;LED is white has to be changed.
#define LED_red	PORTC,3
#define LED_blue	PORTC,4

;***************************************************************************
;                                                                     
;       Memory select macros for PIC 16XXXX
;       ==================================
;
;***************************************************************************


bank0   		macro
        		bcf     STATUS,RP0
        		endm

bank1   		macro
        		bsf     STATUS,RP0
        		endm

res_LED			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00011110'			; table no. 30 = reset.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm

blue_  			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00001001'			; table no. 9 = blue LED ON.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
blue_off		macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00010011'			; table no. 19 = blue LED OFF.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
blue_bl			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00001110'			; table no. 14 = blue LED blink.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
bl_bl_off		macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00011001'			; table no. 25 = blue LED blink off.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
red_  			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00001010'			; table no. 10 = red LED ON.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
red_off			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00010100'			; table no. 20 = red LED OFF.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
red_bl			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00001111'			; table no. 15 = red LED blink.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
red_bl_off	macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00011010'			; table no. 26 = red LED blink off.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
green_			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00001100'			; table no.12 = green LED ON.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
green_off		macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00010110'			; table no. 22 = green LED OFF.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
green_bl		macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00010000'			; table no. 16 = green LED blink.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
gr_bl_off		macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00011011'			; table no. 27 = green LED blink off.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
violet_			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00001011'			; table no. 11 = violet LED ON..		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
viol_off		macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00010101'			; table no. 21 = violet LED OFF.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
viol_bl			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00010001'			; table no. 17 = violet LED blink.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
viol_bl_off	macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00011100'			; table no. 28 = red LED blink off.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
yellow_			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00001101'			; table no. 13 = yellow LED ON.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
yell_off		macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00010111'			; table no. 23 = yellow LED OFF.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
yell_bl			macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00010010'			; table no. 17 = yellow LED blink.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
yel_bl_off	macro
						movlw 	b'00000010'			; page 0, subpage 2.
      			movwf 	PCLATH					
      			movlw		b'00111000'			; table no. 29 = red LED blink off.		
      			call		ser_dir					; P2PSEND.LIB
      			clrf  	PCLATH
						endm
;***************************************************************************
;                                                                     
;      
;       ==================================
;
;***************************************************************************
digbyte macro arg0
	local Pon0
	local Exit1
	local Exit2
	local Pozitiv

	clrf Dig1
	clrf Dig2
	clrf Dig3
Pozitiv	
	movf arg0,w
	movwf Digtemp
	movlw .100
Pon0	
	incf Dig1,f
	subwf Digtemp,f
	btfsc STATUS,C
	goto Pon0
	decf Dig1,f
	addwf Digtemp,f
Exit1	movlw .10
	incf Dig2,f
	subwf Digtemp,f
	btfsc STATUS,C
	goto Exit1
	decf Dig2,f
	addwf Digtemp,f
Exit2
	movf Digtemp,w
	movwf Dig3
	endm

;***************************************************************************
;                                                                     
;      
;       ==================================
;
;***************************************************************************
pausems macro arg1		; for 20Mhz speed
local Loop1
local dechi
local Delay1ms
local Loop2
local Kraj
	ifndef OSC
	#define OSC 20
	endif 

	movlw high (arg1*OSC/5)
	movwf HIcnt
	movlw low (arg1*OSC/5)
	movwf LOcnt
Loop1
	movf LOcnt,f
	btfsc STATUS,Z
	goto dechi	
	call Delay1ms
	decf LOcnt,f
	goto Loop1	
dechi
	movf HIcnt,f
	btfsc STATUS,Z
	goto Kraj
	call Delay1ms
	decf HIcnt,f
	decf LOcnt,f

	goto  Loop1
	
	

Delay1ms:

	movlw .100
	movwf LOOPcnt
Loop2:
	nop		
	nop 
	nop
	;nop	
	;nop 
	nop
	nop
	
	decfsz LOOPcnt,f
	goto Loop2

	return

Kraj
endm
;***************************************************************************
;                                                                     
;      
;       ==================================
;
;***************************************************************************
push macro
	movwf Wtemp
endm


pop macro
	movf Wtemp,w
endm
;***************************************************************************
;                                                                     
;      
;       ==================================
;
;***************************************************************************
;
callz macro label
local Exit
	bnz Exit
	call label
Exit
endm

callnz macro label
local Exit
	bz Exit
	call label
Exit
endm
callc macro label
local Exit
	bnc Exit
	call label
Exit
endm

callnc macro label
local Exit
	bc Exit
	call label
Exit
endm



;***************************************************************************
;                                                                     
;      
;       ==================================
;
;***************************************************************************
input macro dsport,dsbit
	bsf STATUS,RP0
	bsf dsport,dsbit
	bcf STATUS,RP0	
endm

output macro dsport,dsbit
	bsf STATUS,RP0
	bcf dsport,dsbit
	bcf STATUS,RP0	
endm	

;***************************************************************************
;                                                                     
;      
;       ==================================
;
;***************************************************************************
ifbit macro arg1,arg2,arg3
	btfsc arg1,arg2
	goto arg3
endm

ifnotbit macro arg1,arg2,arg3
	btfss arg1,arg2
	goto arg3
endm


;***************************************************************************
;                                                                     
;      
;       ==================================
;
;***************************************************************************
multiply macro arg1, arg2, dest_hi, dest_lo, temp
 local i = 0 
 movf arg1 ,w 
 movwf temp 
 movf arg2,w 
 clrf dest_hi 
 clrf dest_lo 
 bcf STATUS, C  
 while i &lt; 8 
 btfsc temp, i 
 addwf dest_hi, F  
 rrf dest_hi, F   
 rrf dest_lo, F  
 i += 1 
 endw 
endm   

;***************************************************************************
;                                                                     
;      
;       ==================================
;
;***************************************************************************
